<?php
include 'db_connection.php';

// Check if letter_id is provided
if (isset($_GET['letter_id'])) {
    $letter_id = $_GET['letter_id'];
    
    // Fetch the letter details from the database
    $query = "SELECT letters.*, branches.branch_name, users.username AS forward_to_name 
              FROM letters 
              JOIN branches ON letters.branch_id = branches.branch_id 
              LEFT JOIN users ON letters.forward_to = users.user_id 
              WHERE letters.letter_id = ?";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $letter_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $letter = $result->fetch_assoc();
        
        // Output the letter details
        echo "<strong>Letter Number:</strong> " . $letter['letter_number'] . "<br>";
        echo "<strong>Letter Date:</strong> " . $letter['letter_date'] . "<br>";
        echo "<strong>Department:</strong> " . $letter['department'] . "<br>";
        echo "<strong>Subject:</strong> " . $letter['subject'] . "<br>";
        echo "<strong>Branch:</strong> " . $letter['branch_name'] . "<br>";
        echo "<strong>Forward To:</strong> " . ($letter['forward_to_name'] ? $letter['forward_to_name'] : 'N/A') . "<br>";
        echo "<strong>Description:</strong> " . $letter['description'] . "<br>";
        echo "<strong>HOD Comment:</strong> " . $letter['hod_comment'] . "<br>";
        echo "<strong>Priority:</strong> " . $letter['priority'] . "<br>";
        echo "<strong>Scan Copy:</strong> " . ($letter['scan_copy'] ? "<a href='" . $letter['scan_copy'] . "' target='_blank'>View</a>" : 'N/A') . "<br>";
    } else {
        echo "No details found for this letter.";
    }

    $stmt->close();
    $conn->close();
}
?>
