<?php
// Include database connection
include 'db_connection.php';

// Start the session and check if the user is logged in as an approver
session_start();
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'branch_head' && $_SESSION['role'] != 'letter_admin')) {
    echo "<p>You need to be logged in as an approver to access this page.</p>";
    exit;
}

// Fetch the draft letters that are awaiting approval
$query = "SELECT d.draft_id, d.draft_number, d.subject, d.body, u.username as staff_username 
          FROM letter_drafts d 
          JOIN users u ON d.staff_user_id = u.user_id 
          WHERE d.status = 'sent_for_approval' AND d.approver_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $_SESSION['user_id']); // Approver's user ID
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approve Draft Letters</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2 class="mt-4">Approve Draft Letters</h2>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <div class="card mt-4">
                    <div class="card-header">
                        <h4><?php echo $row['draft_number']; ?> - <?php echo $row['subject']; ?></h4>
                        <p>Submitted by: <?php echo $row['staff_username']; ?></p>
                    </div>
                    <div class="card-body">
                        <p><strong>Letter Body:</strong></p>
                        <p><?php echo $row['body']; ?></p>

                        <!-- Form to approve or reject the letter -->
                        <form action="process_approval.php" method="POST">
                            <input type="hidden" name="draft_id" value="<?php echo $row['draft_id']; ?>">
                            <button type="submit" name="approval" value="approved" class="btn btn-success">Approve</button>
                            <button type="submit" name="approval" value="rejected" class="btn btn-danger">Reject</button>
                        </form>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p>No drafts are awaiting your approval.</p>
        <?php endif; ?>
    </div>
</body>
</html>
