<?php
// Include database connection
include '..\db_connection.php';

// Start session and check if the user is logged in
session_start();
if (!isset($_SESSION['user_id'])) {
    echo "<p>You need to be logged in to process the approval.</p>";
    exit;
}

// Check if the approval form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $draft_id = $_POST['draft_id'];
    $approval_status = $_POST['approval']; // approved or rejected
    $comment = $_POST['comment'];
    $new_attachment = null;

    // Check if a new file is uploaded
    if (isset($_FILES['new_attachment']) && $_FILES['new_attachment']['error'] == 0) {
        $file_name = $_FILES['new_attachment']['name'];
        $file_tmp = $_FILES['new_attachment']['tmp_name'];
        $file_size = $_FILES['new_attachment']['size'];
        $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);

        $allowed_extensions = ['pdf', 'docx', 'doc', 'jpg', 'png'];
        if (in_array($file_ext, $allowed_extensions)) {
            // Define the directory where the file will be uploaded
            $upload_dir = 'uploads01/';
            
            // Get the current attachment file path from the database
            $stmt = $conn->prepare("SELECT attachment FROM letter_drafts WHERE draft_id = ?");
            $stmt->bind_param("i", $draft_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            $current_attachment = $row['attachment'];

            // If the current attachment exists, delete it to avoid orphan files
            if ($current_attachment && file_exists($current_attachment)) {
                unlink($current_attachment); // Remove the old file
            }

            // Create a new unique file name to avoid conflicts
            $new_file_name = uniqid('letter_', true) . '.' . $file_ext;
            $file_path = $upload_dir . $new_file_name;

            // Move the uploaded file to the server
            if (move_uploaded_file($file_tmp, $file_path)) {
                $new_attachment = $file_path;  // Store the new file path
            } else {
                echo "<p>Error: Unable to upload the file.</p>";
            }
        } else {
            echo "<p>Error: Invalid file type. Only PDF, DOCX, DOC, JPG, PNG files are allowed.</p>";
        }
    }

    // Update the letter_drafts table with the new approval status and attachment (if any)
    if ($new_attachment) {
        $stmt = $conn->prepare("UPDATE letter_drafts SET status = ?, attachment = ? WHERE draft_id = ?");
        $stmt->bind_param("ssi", $approval_status, $new_attachment, $draft_id);
    } else {
        $stmt = $conn->prepare("UPDATE letter_drafts SET status = ? WHERE draft_id = ?");
        $stmt->bind_param("si", $approval_status, $draft_id);
    }

    $stmt->execute();

    // Insert the approval/rejection record in the database
    $stmt = $conn->prepare("INSERT INTO letter_approvals (draft_id, approver_id, approval_status, approval_comments) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("iiss", $draft_id, $_SESSION['user_id'], $approval_status, $comment);
    $stmt->execute();

    // Redirect back to the list of drafted letters
    header("Location: view_drafted_letters.php");
    exit();
}
?>
