<?php
session_start();

// Require Staff User role
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'staff_user') {
    header('Location: unauthorized.php');
    exit();
}

require_once 'db_connection.php';

// Fetch branch
$user_id = (int)($_SESSION['user_id'] ?? 0);
$branch_name = '—';
if ($user_id) {
    $q = "SELECT b.branch_name FROM users u
          JOIN branches b ON u.branch_id = b.branch_id
          WHERE u.user_id = ?";
    $st = $conn->prepare($q);
    $st->bind_param("i", $user_id);
    $st->execute();
    $st->bind_result($branch_name);
    $st->fetch();
    $st->close();
}
$conn->close();

$username = htmlspecialchars($_SESSION['username'] ?? 'Staff User', ENT_QUOTES, 'UTF-8');
$branch_safe = htmlspecialchars($branch_name ?? '—', ENT_QUOTES, 'UTF-8');
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Staff Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    :root{
      --sidebar-width: 220px;
      --brand: #155eef;
      --brand-hover: #0b51db;
      --sidebar-bg: #0d1320;
    }
    body{ min-height:100vh; background:#f7f9fe; }
    /* Sidebar */
    .sidebar{
      width: var(--sidebar-width);
      background: var(--sidebar-bg);
      color:#cdd7f6;
      position: fixed;
      top:0; left:0; bottom:0;
      overflow-y:auto;
      padding-top:1rem;
    }
    .sidebar .nav-link{
      color:#cdd7f6; border-radius:.5rem; margin:.25rem .5rem;
    }
    .sidebar .nav-link:hover, .sidebar .nav-link.active{
      background:#1b243a; color:#fff;
    }
    /* Content */
    .main{
      margin-left: var(--sidebar-width);
      padding:1.5rem;
    }
    .hero{
      background:#fff; border-radius:1rem; border:1px solid #e0e6f5;
      padding:1.5rem; margin-bottom:1.5rem;
    }
    .card{
      border-radius:.75rem;
      transition:transform .15s, box-shadow .15s;
    }
    .card:hover{ transform:translateY(-2px); box-shadow:0 6px 18px rgba(0,0,0,.06); }
  </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar d-flex flex-column">
  <h5 class="text-center mb-4">Staff User</h5>
  <nav class="nav flex-column">
    <div class="text-uppercase small px-3 mb-2">Letters</div>
    <a class="nav-link" href="staff_pending_letters.php"><i class="bi bi-hourglass-split me-2"></i>Unseen</a>
    <a class="nav-link" href="staff_seen_letters.php"><i class="bi bi-eye me-2"></i>Seen</a>
    <a class="nav-link" href="staff_action_taken.php"><i class="bi bi-check2-circle me-2"></i>Actioned</a>
    <a class="nav-link" href="3days.php"><i class="bi bi-calendar3-event me-2"></i>3 Days</a>

    <div class="text-uppercase small px-3 mt-3 mb-2">Files</div>
    <a class="nav-link" href="file_management_view.php"><i class="bi bi-folder2-open me-2"></i>My Files</a>
    <a class="nav-link" href="out_letter/draft_letter_form.php"><i class="bi bi-file-earmark-text me-2"></i>Draft</a>
    <a class="nav-link" href="out_letter/view_drafted_letters.php"><i class="bi bi-files me-2"></i>View Drafts</a>

    <div class="text-uppercase small px-3 mt-3 mb-2">Profile</div>
    <a class="nav-link" href="staff_view_profile.php"><i class="bi bi-person-lines-fill me-2"></i>View</a>
    <a class="nav-link" href="staff_edit_profile.php"><i class="bi bi-pencil-square me-2"></i>Edit</a>
    <a class="nav-link text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a>
  </nav>
</div>

<!-- Main -->
<main class="main">
  <!-- Hero -->
  <div class="hero d-flex justify-content-between align-items-center">
    <div>
      <h4 class="mb-1">Welcome, <?php echo $username; ?></h4>
      <p class="mb-0 text-secondary">Branch: <strong><?php echo $branch_safe; ?></strong></p>
    </div>
    <img src="logo.jpg" alt="logo" style="width:64px; border-radius:8px;">
  </div>

  <!-- Letter Management -->
  <h5 class="mb-3">Letter Management</h5>
  <div class="row g-3 mb-4">
    <div class="col-md-3 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-hourglass-split fs-2 text-primary"></i></div>
        <h6 class="mt-2">Unseen Letters</h6>
        <a href="staff_pending_letters.php" class="btn btn-sm btn-primary mt-2">Open</a>
      </div>
    </div>
    <div class="col-md-3 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-eye fs-2 text-warning"></i></div>
        <h6 class="mt-2">Seen Letters</h6>
        <a href="staff_seen_letters.php" class="btn btn-sm btn-warning mt-2">Open</a>
      </div>
    </div>
    <div class="col-md-3 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-check2-circle fs-2 text-success"></i></div>
        <h6 class="mt-2">Actioned</h6>
        <a href="staff_action_taken.php" class="btn btn-sm btn-success mt-2">Open</a>
      </div>
    </div>
    <div class="col-md-3 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-calendar3-event fs-2 text-danger"></i></div>
        <h6 class="mt-2">3 Days Pending</h6>
        <a href="3days.php" class="btn btn-sm btn-danger mt-2">Open</a>
      </div>
    </div>
  </div>

  <!-- File Management -->
  <h5 class="mb-3">File Management</h5>
  <div class="row g-3 mb-4">
    <div class="col-md-4 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-folder2-open fs-2 text-success"></i></div>
        <h6 class="mt-2">View Files</h6>
        <a href="file_management_view.php" class="btn btn-sm btn-success mt-2">Open</a>
      </div>
    </div>
    <div class="col-md-4 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-file-earmark-text fs-2 text-primary"></i></div>
        <h6 class="mt-2">Draft Letter</h6>
        <a href="out_letter/draft_letter_form.php" class="btn btn-sm btn-primary mt-2">Open</a>
      </div>
    </div>
    <div class="col-md-4 col-sm-6">
      <div class="card text-center p-3">
        <div><i class="bi bi-files fs-2 text-info"></i></div>
        <h6 class="mt-2">Drafts</h6>
        <a href="out_letter/view_drafted_letters.php" class="btn btn-sm btn-info mt-2">Open</a>
      </div>
    </div>
  </div>

  <!-- Profile -->
  <h5 class="mb-3">Profile</h5>
  <div class="row g-3 mb-5">
    <div class="col-md-4 col-sm-6">
      <a class="btn btn-outline-primary w-100 py-3" href="staff_view_profile.php"><i class="bi bi-person-lines-fill me-2"></i>View Profile</a>
    </div>
    <div class="col-md-4 col-sm-6">
      <a class="btn btn-outline-secondary w-100 py-3" href="staff_edit_profile.php"><i class="bi bi-pencil-square me-2"></i>Edit Profile</a>
    </div>
    <div class="col-md-4 col-sm-6">
      <a class="btn btn-outline-danger w-100 py-3" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Logout</a>
    </div>
  </div>

  <footer class="text-center text-muted small py-3 border-top">
    © <?php echo date('Y'); ?> Valvettiturai Urban Council
  </footer>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
